/**
  @file             SM_HLL.h
  @version          0.1.0.0

  @brief            
  @details          

  Project           Stepper Motor Driver
  Platform          MPC5606S

  SWVersion         0.1.0


  (c) Copyright 2011 Freescale Semiconductor Inc.
  All Rights Reserved.
*/
/*==================================================================================================
==================================================================================================*/

#ifndef SM_HLL
    #define SM_HLL    
    
/*==================================================================================================
                                 STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/

typedef struct		/* Structure contains all mechanical parameters of the motor defined by user */
{
	SM_MtrModel_t		eMtrModel;
	SM_NominalDir_t		eNominalDirection;
	SM_AlgoType_t		eAlgoType;
	SM_UpdateTime_t		eUpdateTime;
	uint16_t			u16MtrMaxVel;		/* Maximum motor velocity */
	uint16_t			u16MtrMaxAcc;		/* Maximum motor acceleration */
	uint16_t			u16MtrMaxDec;		/* Maximum motor acceleration */
	uint16_t			u16DampingFactor;	
	uint16_t			u16Threshold1;
	uint16_t			u16Threshold2;
	uint16_t			u16Threshold3;
	uint16_t			u16Threshold4;
	uint8_t				u8ClockDelay;
	
	SM_RtzType_t		eRtzType;
	SM_RtzQuadrant_t	eRtzStartQuad;
	SM_RtzThreshold_t	eRtzBackEmfThreshold;		/* Threshold of the stall detection */ 
	uint16_t			u16RtzSyncStartAngle;
	uint16_t			u16RtzSyncEndAngle;
	uint16_t			u16RtzSyncStep;
	uint16_t			u16RtzSyncStepDuration;	
	uint16_t 			u16RtzBlankTimeUs;			/* Blanking time in us */
	uint16_t 			u16RtzIntegTimeUs;			/* Velocity of the RTZ movement */
}HLL_MotorParams_t;

/*==================================================================================================
                                       DEFINES AND MACROS
==================================================================================================*/

#define HLL_TABLELENGTH					LLL_TABLELENGTH		/* HLL Table length abstraction */

/*==================================================================================================
                                     FUNCTION PROTOTYPES
==================================================================================================*/

/* Function initializes Stepper Motor Driver for "eMtrId" motor according to "rMtrParams" parameters */ 
SM_Err_t SM_MotorInit(SM_MotorId_t eMtrId, HLL_MotorParams_t *rMtrParams);

/* Function disables Stepper Motor Driver for "eMtrId" motor */
SM_Err_t SM_MotorDisable(SM_MotorId_t eMtrId);

/* Function initializes motor movement of the "eMtrId" motor to the required position (s32Pos) by the
	 defined velocity (u32Vel) */ 
SM_Err_t SM_GoToPosition(SM_MotorId_t eMtrId, uint16_t u16Pos);

SM_Err_t SM_GetActualVariable(SM_MotorId_t eMtrId, SM_ActualVariable_t eActVar, int16_t *ps16Var);

SM_Err_t SM_SetActualVariable(SM_MotorId_t eMtrId, SM_ActualVariable_t eActVar, int16_t s16Var);

SM_Err_t SM_SetCoilOutputs(SM_MotorId_t eMtrId, uint16_t u16CosPwm, uint16_t u16SinPwm, SM_RtzQuadrant_t eQuad);

/* Function freezes "eMtrId" */
SM_Err_t SM_Disable(SM_MotorId_t eMtrId);

/* Function unfreezes "eMtrId" motor */
SM_Err_t SM_ReEnable(SM_MotorId_t u8MtrId);

/* Function initializes the RTZ movement of the "eMtrId" motor according to "prRtzParams" parameters */
SM_Err_t SM_Rtz(SM_MotorId_t eMtrId);	

SM_Err_t SM_GetActualStopQuadrant(SM_MotorId_t eMtrId, SM_RtzQuadrant_t *eQuadrant);

/* Function reads actual status of the "eMtrId" motor. Motor status is written into the "peMtrStatus" address */  
SM_Err_t SM_ReadMtrStatus(SM_MotorId_t eMtrId,SM_MotorState_t *peMtrStatus);

#endif /* SM_HLL */
